//---------------------------------------------------------------
// Fichero:  enunciado03.asy
// Objetivo: Enunciado 3
// Fecha:    X.16.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    { return string(round(length(A-B))); }

// Los vértices
pair A=(0,0), B=(50,0), C=(50,29), D=(63,29), E1=(63,52), F=(25,52),
     G=(25,39), H=(0,39);

// El polígono
draw(A -- B -- C -- D -- E1 -- F -- G -- H -- cycle);

// Las medidas
label(Dist(A,B), (A+B)/2, S, blue);
label(Dist(C,D), (C+D)/2, S, blue);
label(Dist(D,E1), (D+E1)/2, E, blue);
label(Dist(E1,F), (E1+F)/2, N, blue);
label(Dist(F,G), (F+G)/2, W, blue);
label(Dist(H,A), (H+A)/2, W, blue);
