//---------------------------------------------------------------
// Fichero:  solucion1.asy
// Objetivo: Solución 1
// Fecha:    V.25.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(7.5cm);

// Constantes
int TotFil = 6, TotCol = 11;

// Función que dibuja un rectángulo de la solución
void DibujaRectangulo(pair Origen)
    {
    draw(box(Origen,Origen+(2,1)),heavygreen);
    dot(Origen,3bp+deepgreen);
    dot(Origen+(2,1),3bp+deepgreen);
    dot(Origen+(2,0),3bp+deepgreen);
    dot(Origen+(0,1),3bp+deepgreen);
    }

// Los puntos básicos
for ( int i=0 ; i<TotCol ; ++i )
    {
    for ( int j=0 ; j<TotFil ; ++j )
        { dot((i,j),3bp+gray); }
    }

// Los rectángulos
for ( int i=1 ; i<TotCol-2 ; i+=2 )
    {
    for ( int j=1 ; j<TotFil-2 ; ++j )
        { DibujaRectangulo((i,j)); }
    }
