//---------------------------------------------------------------
// Fichero:  enunciado2.asy
// Objetivo: Mostrar el enunciado 2
// Fecha:    V.4.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    { return string(round(length(A-B))); }

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(-45,0), B=(45,0), C=(36,40), D=(-36,40);

// Las alturas
pair Q=(-36,0), R=(36,0);
pen Punteado = linetype(new real[] {2,2});
draw(D -- Q, heavygray+Punteado);
draw(C -- R, heavygray+Punteado);
markrightangle(D, Q, A, 2mm, 0.5bp+gray);
markrightangle(C, R, B, 2mm, 0.5bp+gray);

// El trapecio
draw(A -- B -- C -- D -- cycle);

// Las medidas
label(Dist(A,B), (A+B)/2, S, blue);
label(Dist(C,D), (C+D)/2, N, blue);
label("$x$", (B+C)/2, E, blue);
label("$x$", (D+A)/2, W, blue);
label(Dist(D,Q), (D+Q)/2, E, blue);
label(Dist(C,R), (C+R)/2, W, blue);

// Una flecha
draw((55,20) -- (70,20), 0.5mm+deepgreen,Arrow(size=2.5mm));

// El triángulo
transform t=shift(50,0);
pair R1=t*R, B1=t*B, C1=t*C;
markrightangle(B1, R1, C1, 2mm, 0.5bp+gray);
draw(R1 -- B1 -- C1 -- cycle);
label(Dist(R1,B1), (R1+B1)/2, S, blue);
label("$x$", (B1+C1)/2, E, blue);
label(Dist(R1,C1), (R1+C1)/2, W, blue);
