//---------------------------------------------------------------
// Fichero:  enunciado1.asy
// Objetivo: Mostrar el enunciado 1
// Fecha:    V.4.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    { return string(round(length(A-B))); }

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(-46,0), B=(46,0), C=(25,20), D=(-25,20);

// Las alturas
pair Q=(-25,0), R=(25,0);
pen Punteado = linetype(new real[] {2,2});
draw(D -- Q, heavygray+Punteado);
draw(C -- R, heavygray+Punteado);
markrightangle(D, Q, A, 0.5bp+gray);
markrightangle(C, R, B, 0.5bp+gray);

// El trapecio
draw(A -- B -- C -- D -- cycle);

// Las medidas
label(Dist(A,B), (A+B)/2, S, blue);
label(Dist(C,D), (C+D)/2, N, blue);
label(Dist(B,C), (B+C)/2, NE, blue);
label(Dist(D,A), (D+A)/2, NW, blue);
label("$h$", (D+Q)/2, E, blue);
label("$h$", (C+R)/2, W, blue);

// Una flecha
draw((47,10) -- (57,10), 0.5mm+deepgreen,Arrow(size=2.5mm));

// El triángulo
transform t=shift(40,0);
pair R1=t*R, B1=t*B, C1=t*C;
markrightangle(B1, R1, C1, 0.5bp+gray);
draw(R1 -- B1 -- C1 -- cycle);
label(Dist(R1,B1), (R1+B1)/2, S, blue);
label(Dist(B1,C1), (B1+C1)/2, NE, blue);
label("$h$", (R1+C1)/2, W, blue);
