//---------------------------------------------------------------
// Fichero:  angulos.asy
// Objetivo: Representar los ángulos de un rombo
// Fecha:    M.25.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,-3), B=(6,0), C=(0,3), D=(-6,0);

// Los ángulos
pen FormAng=fontsize(9pt)+blue;
pen FormArc=0.5bp+blue;
markangle(Label("$\hat{\textup{A}}$",FormAng),n=1,radius=2mm,B,A,D,FormArc);
markangle(Label("$\hat{\textup{C}}$",FormAng),n=1,radius=2mm,D,C,B,FormArc);
markangle(Label("$\hat{\textup{B}}$",FormAng),n=2,radius=4mm,C,B,A,FormArc);
markangle(Label("$\hat{\textup{D}}$",FormAng),n=2,radius=4mm,A,D,C,FormArc);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);

// Los vértices
dot("A", A, S, 3bp+black);
dot("B", B, E, 3bp+black);
dot("C", C, N, 3bp+black);
dot("D", D, W, 3bp+black);
