//---------------------------------------------------------------
// Fichero:  trapecioisosceles.asy
// Objetivo: Representar un trapecio isósceles
// Fecha:    D.23.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para StickIntervalMarker()
import markers;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(12,0), C=(10,3), D=(2,3);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);

// Las marcas
marker Formato = StickIntervalMarker(i=1, n=2, angle=45, size=3mm,
                                    space=1mm, p=blue);
draw(B -- C, Formato);
draw(A -- D, Formato);
