//---------------------------------------------------------------
// Fichero:  concavo.asy
// Objetivo: Representar un cuadrilátero cóncavo con sus ángulos
// Fecha:    V.21.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0cm,4cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(-2,-2.5), C=(7,1), D=(-1,3);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);

// Los vértices
dot("A", A, W, 3bp+black);
dot("B", B, SW, 3bp+black);
dot("C", C, E, 3bp+black);
dot("D", D, NW, 3bp+black);

// Los ángulos
pen FormAng=fontsize(8pt)+blue;
pen FormArc=0.5bp+blue;
markangle(Label("$\hat{\textup{A}}$",FormAng), radius=5mm, B, A, D, FormArc);
markangle(Label("$\hat{\textup{B}}$",FormAng), radius=8mm, C, B, A, FormArc);
markangle(Label("$\hat{\textup{C}}$",FormAng), radius=8mm, D, C, B, FormArc);
markangle(Label("$\hat{\textup{D}}$",FormAng), radius=8mm, A, D, C, FormArc);
