//---------------------------------------------------------------
// Fichero:  ejemplo2.asy
// Objetivo: Representar un cuadrilátero con su notación
// Fecha:    V.21.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0cm,4cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(15,1), C=(10,4), D=(1,3);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);

// Los vértices
dot("A", A, SW, 3bp+black);
dot("B", B, E, 3bp+black);
dot("C", C, NE, 3bp+black);
dot("D", D, NW, 3bp+black);

// Los ángulos
pen FormAng=fontsize(18pt)+blue;
pen FormArc=0.5bp+blue;
markangle(Label("$\alpha$",FormAng), radius=6mm, B, A, D, FormArc);
markangle(Label("$\beta$",FormAng), radius=10mm, C, B, A, FormArc);
markangle(Label("$\gamma$",FormAng), radius=6mm, D, C, B, FormArc);
markangle(Label("$\delta$",FormAng), radius=6mm, A, D, C, FormArc);
