//---------------------------------------------------------------
// Fichero:  rombo3.asy
// Objetivo: Ejercicio sobre rombo
// Fecha:    M.8.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para StickIntervalMarker()
import markers;

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    { return string(round(length(A-B))); }

// Función que devuelve un vector perpendicular al segmento dado
pair Perpendicular(pair A, pair B)
    { return (A.y - B.y, B.x - A.x); }

// Grosor de las líneas
defaultpen(1);

// El giro
transform r=rotate(20);

// Los vértices
pair A=r*(0,-37), B=r*(27,0), C=r*(0,37), D=r*(-27,0);

// La altura
pair P=D+0.4*(C-D);
pair Q=extension(A, B, P, P+Perpendicular(A,B));
draw(P -- Q, heavygray);
markrightangle(D, P, Q, 0.5bp+gray);
markrightangle(A, Q, P, 0.5bp+gray);

// El rombo
draw(A -- B -- C -- D -- cycle);

// Las marcas
marker FormExt = StickIntervalMarker(i=1, n=2, angle=45, size=3mm,
                                    space=1mm, p=blue);
draw(A -- B, FormExt);
draw(B -- C, FormExt);
draw(C -- D, FormExt);
draw(D -- A, FormExt);

// Las medidas
label(Dist(A,B), (A+B)/2, SE, blue);
label(Dist(P,Q), (P+Q)/2, NE, blue);
