//---------------------------------------------------------------
// Fichero:  corona.asy
// Objetivo: Representar una corona circular y sus radios
// Fecha:    L.5.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.5cm);

// Grosor de las líneas
defaultpen(1);

// Los radios
int r=4, s=3;

// El centro
pair T=(0,0);

// Un punto de cada circunferencia
pair Pr=r*(Cos(70),Sin(70)), Ps=s*(Cos(170),Sin(170));

// La corona
filldraw(circle(T,r),lightgray,black);
filldraw(circle(T,s),white,black);

// Los puntos
dot(T, 3bp+black);
dot(Pr, 3bp+black);
dot(Ps, 3bp+black);

// Las flechas
draw(T -- Pr, blue, Arrows(HookHead,5bp));
draw(T -- Ps, blue, Arrows(HookHead,5bp));

// Los nombres
label("$r$", (T+Pr)/2, SE, blue);
label("$s$", (T+Ps)/2, S, blue);
