//---------------------------------------------------------------
// Fichero:  sagita.asy
// Objetivo: Representar una sagita
// Fecha:    X.30.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.75cm);

// Grosor de las líneas
defaultpen(1);

// La circunferencia
draw(circle((0,0),1));

// Dos puntos de la circunferencia
pair A=(Cos(30),Sin(30)), B=(Cos(170),Sin(170));

// La cuerda
draw(A -- B, 2bp+gray);

// Los puntos medios
pair M=(Cos(100),Sin(100)), N=(A+B)/2;

// La sagita
draw(M -- N, 2bp+blue);

// Los puntos
dot(A, 3bp+black);
dot(B, 3bp+black);
dot(M, 3bp+black);
dot(N, 3bp+black);
