//---------------------------------------------------------------
// Fichero:  secantes.asy
// Objetivo: Recta y circunferencia secantes
// Fecha:    M.29.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Definición del centro y dos puntos
pair T=(0,0), A=(-0.8,-1.1), B=(0.3,1.1);

// La circunferencia
draw(circle(T,1));

// La recta
draw(A -- B);

// Los puntos de corte
pair Cortes[] = intersectionpoints(A -- B, circle(T,1));
for ( pair K : Cortes )
    { dot(K, 3bp+blue); }
