//---------------------------------------------------------------
// Fichero:  enunciado5.asy
// Objetivo: Enunciado 5
// Fecha:    M.6.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2, int e)
    { return string(round(degrees(P1-V)-degrees(P2-V))+360*e)+"$^\circ$"; }

// El centro de la circunferencia
pair T=(0,0);

// Un punto de la circunferencia
pair V=(Cos(154),Sin(154));

// El punto de tangencia
pair A=(0,-1);

// Un punto auxiliar
pair R=(-1,-1);

// El punto exterior
pair Q=extension(V, T, R, A);

// Los ángulos
markangle(Ang(R,Q,V,0), radius=8mm, V, Q, R, blue);
markangle("$\alpha$", radius=10mm, V, A, R, blue);

// La circunferencia
draw(circle(T,1));

// Los ángulos
draw(V -- Q -- R);
draw(V -- A -- R);

// Los puntos
dot(T, 3bp+black);
dot(Q, 3bp+black);
dot(A, 3bp+black);
