//---------------------------------------------------------------
// Fichero:  enunciado2.asy
// Objetivo: Enunciado 2
// Fecha:    M.6.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve un vector perpendicular al segmento dado
pair Perpendicular(pair A, pair B)
    { return (A.y - B.y, B.x - A.x); }

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2, int e)
    { return string(round(degrees(P1-V)-degrees(P2-V))+360*e)+"$^\circ$"; }

// El centro de la circunferencia
pair T=(0,0);

// Dos puntos de la circunferencia
pair A=(Cos(-80),Sin(-80)), B=(Cos(60),Sin(60));

// El punto exterior
pair Q=extension(A, A+Perpendicular(T,A), B, B+Perpendicular(T,B));

// Los ángulos
markangle(Ang(B,A,Q,0), radius=10mm, Q, A, B, blue);
markangle("$\alpha$", radius=10mm, A, B, Q, blue);

// La circunferencia
draw(circle(T,1));

// Línea auxiliar
draw(A -- B);

// Los puntos
dot(T, 3bp+black);
dot(A, 3bp+black);
dot(B, 3bp+black);

// Las rectas
pair Sep=0.3*(A-Q);
draw(A+Sep -- Q+Sep);
pair Sep=0.3*(B-Q);
draw(B+Sep -- Q+Sep);
