//---------------------------------------------------------------
// Fichero:  enunciado11.asy
// Objetivo: Representar el enunciado 11
// Fecha:    V.2.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2, int e)
    { return string(round(degrees(P2-V)-degrees(P1-V))+360*e)+"$^\circ$"; }

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return (Cos(angulo),Sin(angulo)); }

// Puntos de la circunferencia que son vértices
pair V1=PuntoCir(280), V2=PuntoCir(36), V3=PuntoCir(136);

// Puntos de la circunferencia que son extremos de arco
pair A=PuntoCir(-20), B=PuntoCir(88), C=PuntoCir(212);

// El centro de la circunferencia
pair T=(0,0);
dot(T,4bp+black);

// Los ángulos
markangle("$\alpha$", radius=4mm, A, V1, C, 0.5bp+blue);
markangle(Ang(B,V2,A,0), radius=4mm, B, V2, A, 0.5bp+blue);
markangle(Ang(C,V3,B,1), radius=4mm, C, V3, B, 0.5bp+blue);

// La circunferencia
draw(circle(T,1));

// Los radios
draw(T -- A);
draw(T -- B);
draw(T -- C);

// Los lados de los ángulos
draw(C -- V1 -- A);
draw(A -- V2 -- B);
draw(B -- V3 -- C);
