//---------------------------------------------------------------
// Fichero:  solucion1.asy
// Objetivo: Representar la solución 1
// Fecha:    L.26.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle(), markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// El vértice
pair V=(0,0);

// Los extremos de las rectas
pair R1=(-4,-2), R2=(4,2);
pair S1=(-4,2), S2=(4,-2);
pair T=(-1,2);

// Los ángulos
markangle("$\alpha$", radius=4mm, S2, V, T, 0.5bp+blue);
markangle("$\beta$", radius=10mm, S2, V, R2, 0.5bp+blue);
markangle("$32^\circ$", radius=3mm, S1, V, R1, 0.5bp+blue);
markrightangle(R2, V, T, 2mm, gray);

// Dibujamos las rectas
draw(R1 -- R2);
draw(S1 -- S2);
draw(V -- T);
