//---------------------------------------------------------------
// Fichero:  perpendiculares3.asy
// Objetivo: Representar ángulos suplementarios de lados perpendiculares
// Fecha:    D.25.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle(), markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair V1=(0,0), V2=(3,2);

// Los extremos de las rectas
pair R1=(4,0), S1=(3,4);
pair R2=(3,-0.3), S2=(1,3.5);

// Los ángulos
markangle("$\alpha$", radius=5mm, R1, V1, S1, 0.5bp+blue);
markangle("$\beta$", radius=5mm, S2, V2, R2, 0.5bp+blue);

// Marcamos los ángulos rectos
markrightangle(V2, intersectionpoint(V2 -- S2, V1 -- S1), V1, 2mm, gray);
markrightangle(V2, intersectionpoint(V2 -- R2, V1 -- R1), V1, 2mm, gray);

// Dibujamos las rectas
draw(S1 -- V1 -- R1);
draw(S2 -- V2 -- R2);
