//---------------------------------------------------------------
// Fichero:  llano.asy
// Objetivo: Representar dos ángulos llanos
// Fecha:    X.21.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// El vértice
pair V=(0,0);

// Los extremos
pair L1=(1,0), L2=(-1,0);

// Los ángulos
markangle(radius=5mm, L1, V, L2, 0.5bp+black);
markangle(radius=3mm, L2, V, L1, 0.5bp+black);

// Dibujamos los lados
draw(L1 -- L2);

// Marcamos el vértice
dot(V, 4bp+black);
