//---------------------------------------------------------------
// Fichero:  dosangulos.asy
// Objetivo: Representar dos ángulos
// Fecha:    X.21.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo EPS
settings.outformat="eps";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// El vértice
pair V=(0,0);

// Los extremos de los lados
pair L1 = (1.2,1.2);
pair L2 = (1.2,-1.2);

// El sector pequeño relleno
pair M1=(1,1), M2=(1,-1), Final=(1,0);
pen ColorInicial=magenta, ColorFinal=pink;
path Sector = buildcycle(arc(V,M2,M1), M1 -- V -- M2);
radialshade(Sector, ColorInicial, V, 0.1, ColorFinal, V, 0.9);

// El sector grande relleno
pair M1=(1,1), M2=(1,-1), Final=(-1,0);
pen ColorInicial=cyan, ColorFinal=palecyan;
path Sector = buildcycle(arc(V,M1,M2), M2 -- V -- M1);
radialshade(Sector, ColorInicial, V, 0.1, ColorFinal, V, 0.9);

// Dibujamos los lados
draw(V -- L1);
draw(V -- L2);

// Marcamos el vértice
dot(V, 4bp+black);
