//---------------------------------------------------------------
// Fichero:  enunciado15.asy
// Objetivo: Representar el enunciado 15
// Fecha:    M.27.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return (Cos(angulo),Sin(angulo)); }

// Los extremos de las rectas
pair R1=(-1,3), R2=(1,-4);
pair S=(-6,-3);
pair T1=(-6,0), T2=(3,0);
pair U1=(-6,-2), U2=(3,-2);

// Los vértices
pair V1=intersectionpoint(T1 -- T2, R1 -- R2);
pair V2=intersectionpoint(U1 -- U2, R1 -- R2);
pair V3=intersectionpoint(T1 -- T2, R1 -- S);

// Vector que une R1 y S
pair Vector=0.5*(R1-S);

// Paralela a R1 y S que pasa por V2
pair W1=V2+Vector, W2=V2-0.6*Vector;

// Los ángulos
markangle("$\alpha$", radius=4mm, W2, V2, R2, 0.5bp+blue);
markangle("$108^\circ$", radius=3mm, T2, V1, R1, 0.5bp+blue);
markangle("$50^\circ$", radius=5mm, T1, V3, S, 0.5bp+blue);

// Dibujamos las rectas
draw(R1 -- R2);
draw(R1 -- S);
draw(T1 -- T2);
draw(U1 -- U2);
draw(W1 -- W2);

