//---------------------------------------------------------------
// Fichero:  enunciado12.asy
// Objetivo: Representar el enunciado 12
// Fecha:    M.27.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Los extremos de las rectas
pair R=(1,2.5);
pair S=(-1,2.5);
pair T=(-2,0);

// El vértice
pair V=(0,0);

// Los ángulos
markangle("$\alpha$", radius=4mm, (1,0), V, R, 0.5bp+blue);
markangle("$70^\circ$", radius=6mm, S, V, T, 0.5bp+blue);
markangle("$42^\circ$", radius=6mm, T, S, V, 0.5bp+blue);

// Dibujamos las rectas
draw(T -- S -- V -- R);
draw((1,0) -- T);
