//---------------------------------------------------------------
// Fichero:  enunciado08.asy
// Objetivo: Representar el enunciado 8
// Fecha:    M.27.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle(), markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return (Cos(angulo),Sin(angulo)); }

// Los extremos de las rectas
pair R1=PuntoCir(42), R2=-0.8*R1;
pair S1=(0.8,0), S2=(-0.7,0);
pair T1=(0.8,-0.3), T2=(-0.7,-0.3);
pair A=0.8*PuntoCir(25);

// Un vértice
pair V=intersectionpoint(R1 -- R2, T1 -- T2);

// Puntos de corte
pair KR=intersectionpoint(shift(A)*rotate(90)*(3*R1 -- 3*R2), R1 -- R2);
pair KS=intersectionpoint(shift(A)*rotate(90)*(3*S1 -- 3*S2), S1 -- S2);

// Los ángulos
markangle("$\alpha$", radius=5mm, T1, V, R1, 0.5bp+blue);
markangle("$76^\circ$", radius=3mm, KR, A, KS, 0.5bp+blue);
markrightangle(R1, KR, A, 2mm, gray);
markrightangle(S2, KS, A, 2mm, gray);

// Dibujamos las rectas
draw(R1 -- R2);
draw(S1 -- S2);
draw(T1 -- T2);
draw(A -- KR);
draw(A -- KS);
