//---------------------------------------------------------------
// Fichero:  enunciado07.asy
// Objetivo: Representar el enunciado 7
// Fecha:    M.27.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return (Cos(angulo),Sin(angulo)); }

// Los extremos de las rectas
pair R1=PuntoCir(22), R2=-R1;
pair S1=PuntoCir(-11), S2=-S1;

// Las rectas
path rectaR1 = R1 -- R2;
path rectaR2 = shift(0,0.2)*rectaR1;
path rectaS1 = S1 -- S2;
path rectaS2 = shift(0,-0.2)*rectaS1;

// Los vértices
pair V1=intersectionpoint(rectaR1, rectaS1);
pair V2=intersectionpoint(rectaR2, rectaS2);
pair V3=intersectionpoint(rectaR1, rectaS2);
pair V4=intersectionpoint(rectaR2, rectaS1);

// Los ángulos
markangle("$\alpha$", radius=1mm, shift(0,0.2)*R1, V2, shift(0,-0.2)*S2, 0.5bp+blue);
markangle("$33^\circ$", radius=5mm, S1, V1, R1, 0.5bp+blue);

// Dibujamos las rectas
draw(rectaR1);
draw(rectaR2);
draw(rectaS1);
draw(rectaS2);
