//---------------------------------------------------------------
// Fichero:  enunciado02.asy
// Objetivo: Representar el enunciado 2
// Fecha:    M.27.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle(), markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return (Cos(angulo),Sin(angulo)); }

// Los extremos de las rectas
pair R1=PuntoCir(25), R2=-0.2*R1;
pair S1=(0.9,0), S2=(-0.3,0);
pair T1=(0,-0.2), T2=(0,0.8);

// El vértice
pair V=(0,0);

// Los ángulos
markangle("$\alpha$", radius=10mm, S1, V, R1, 0.5bp+blue);
markangle("$65^\circ$", radius=8mm, R1, V, T2, 0.5bp+blue);
markrightangle(S1, V, T2, 4mm, gray);

// Dibujamos las rectas
draw(R1 -- R2);
draw(S1 -- S2);
draw(T1 -- T2);
