//---------------------------------------------------------------
// Fichero:  enunciado1.asy
// Objetivo: Representar el enunciado 1
// Fecha:    X.10.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Para los caracteres no ASCII
import unicode;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// El rectángulo que marca el total
draw(box((0,0),(7,3)));

// La línea vertical
draw((5,0) -- (5,3));

// La separación entre las flechas y el objeto
real Separacion = 0.3;

// Las flechas que marcan los datos y la incógnita
draw((0,3+Separacion) -- (7,3+Separacion),
     blue, Arrows(HookHead,5bp), Bars(2mm));
draw((5,-Separacion) -- (7,-Separacion),
     blue, Arrows(HookHead,5bp), Bars(2mm));

// Los datos y la incógnita
label("136", (3.5,3+2*Separacion), fontsize(16pt));
label("¿?", (6,-2*Separacion), fontsize(16pt));
label("$\frac{15}{17}$", (2.5,1.5), fontsize(24pt));
