//---------------------------------------------------------------
// Fichero:  regla.asy
// Objetivo: Representar gráficamente el cociente de fracciones
// Fecha:    X.3.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// El tamaño de los símbolos
real Tam = 1;

// La separación entre los dos miembros
real Sep = 4*Tam;

// Los símbolos
path Cuadrado = box((0,0), (Tam,Tam));
path Circulo = circle((Tam/2,0), Tam/2);

// Colocación de los símbolos de la izquierda
fill(Cuadrado, red);
fill(shift(0,2*Tam)*Circulo, red);
fill(shift(1.5*Tam,0)*Cuadrado, blue);
fill(shift(1.5*Tam,2*Tam)*Circulo, blue);

// Colocación de los símbolos de la derecha
fill(shift(Sep,0)*Cuadrado, red);
fill(shift(Sep,2*Tam)*Circulo, red);
fill(shift(Sep+1.5*Tam,1.5*Tam)*Cuadrado, blue);
fill(shift(Sep+1.5*Tam,0.5*Tam)*Circulo, blue);

// Las líneas de fracción
path Linea = (0,0) -- (Tam,0);
draw(shift(0,1.25*Tam)*Linea);
draw(shift(1.5*Tam,1.25*Tam)*Linea);
draw(shift(Sep,1.25*Tam)*Linea);
draw(shift(Sep+0.75*Tam,1.25*Tam)*Linea);
draw(shift(Sep+1.5*Tam,1.25*Tam)*Linea);

// El signo de igualdad
draw ((3.1*Tam,1.2*Tam) -- (3.4*Tam,1.2*Tam));
draw ((3.1*Tam,1.3*Tam) -- (3.4*Tam,1.3*Tam));

// Las flechas
pair A = (0.5*Tam, 2*Tam);
pair B = (2*Tam, 0.5*Tam);
pair C = (3.25*Tam, 2*Tam);
pair D = (3.7*Tam, 2*Tam);
draw(A -- B -- C -- D, deepgreen, Arrow(5bp));
pair E = (0.5*Tam, 0.5*Tam);
pair F = (2*Tam, 2*Tam);
pair G = (3.25*Tam, 0.5*Tam);
pair H = (3.7*Tam, 0.5*Tam);
draw(E -- F -- G -- H, olive, Arrow(5bp));

// El punto de multiplicar
path Punto = circle((0,0), Tam/15);
fill(shift(1.25,1.25)*scale(1.2)*Punto, white);
fill(shift(1.25,1.25)*Punto);
fill(shift(Sep+1.25,2*Tam)*Punto);
fill(shift(Sep+1.25,0.5*Tam)*Punto);
