//---------------------------------------------------------------
// Fichero:  sumadistinto.asy
// Objetivo: Representar una suma de fracciones con distinto denominador
// Fecha:    V.26.2.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(15cm);

// Grosor de las líneas
defaultpen(1);

// El rectángulito básico
real Anchura = 0.5;
path Rectangulo = box((0,0), (Anchura,1));

// El rectángulo triple
path RectanguloTriple = box((0,0), (3*Anchura,1));

// El rectángulo quíntuple
path RectanguloQuintuple = box((0,0), (5*Anchura,1));

// Las separaciones entre las representaciones de las fracciones
real SeparacionVertical = 1;
real SeparacionHorizontal = 20*Anchura;

// Los rectángulos que marcan los numeradores
fill(box((10*Anchura,1+SeparacionVertical),(15*Anchura, 2+SeparacionVertical)),
          mediumgray);
fill(box((0,2+2*SeparacionVertical),(6*Anchura, 3+2*SeparacionVertical)),
          mediumgray);
fill(box((SeparacionHorizontal+10*Anchura,1+SeparacionVertical),
         (SeparacionHorizontal+15*Anchura, 2+SeparacionVertical)),
          mediumgray);
fill(box((SeparacionHorizontal,2+2*SeparacionVertical),
         (SeparacionHorizontal+6*Anchura, 3+2*SeparacionVertical)),
          mediumgray);
fill(box((SeparacionHorizontal,0),
         (SeparacionHorizontal+11*Anchura, 1)),
          mediumgray);

// Las dos fracciones originales van a la izquierda
for ( int i=0 ; i<3 ; ++i )
    { draw(shift(5*Anchura*i, 1+SeparacionVertical) * RectanguloQuintuple); }
for ( int i=0 ; i<5 ; ++i )
    { draw(shift(3*Anchura*i, 2+2*SeparacionVertical) * RectanguloTriple); }

// Las representaciones de las fracciones de la derecha
for ( int i=0 ; i<15 ; ++i )
    { draw(shift(SeparacionHorizontal+Anchura*i, 0) * Rectangulo); }
for ( int i=0 ; i<3 ; ++i )
    {
    draw(shift(SeparacionHorizontal+5*Anchura*i, 1+SeparacionVertical)
     * RectanguloQuintuple);
    }
for ( int i=0 ; i<5 ; ++i )
    {
    draw(shift(SeparacionHorizontal+3*Anchura*i, 2+2*SeparacionVertical)
     * RectanguloTriple);
    }

// Las líneas que dividen las partes
pen Punteado = linetype(new real[] {2,2});
path Linea = (0,0) -- (0,1);
for ( int i=1 ; i<15 ; ++i )
    {
    draw(shift(SeparacionHorizontal+Anchura*i, 1+SeparacionVertical) * Linea,
         Punteado);
    draw(shift(SeparacionHorizontal+Anchura*i, 2+2*SeparacionVertical) * Linea,
         Punteado);
    }

// Las frechas que van desde las fracciones originales a las equivalentes
draw((16*Anchura,1.5+SeparacionVertical) --
     (18*Anchura,1.5+SeparacionVertical), deepgreen, Arrow(5bp));
draw((16*Anchura,2.5+2*SeparacionVertical) --
     (18*Anchura,2.5+2*SeparacionVertical), deepgreen, Arrow(5bp));

// Las frechas que van desde los sumandos hasta el resultado
for ( int i=0 ; i<6 ; ++i )
    {
    draw((SeparacionHorizontal+(i+0.5)*Anchura,1.9+2*SeparacionVertical) --
         (SeparacionHorizontal+(i+0.5)*Anchura,1.1),
          deepgreen, Arrow(5bp));
    }

for ( int i=6 ; i<11 ; ++i )
    {
    draw((SeparacionHorizontal+(i+4+0.5)*Anchura,0.9+SeparacionVertical) --
         (SeparacionHorizontal+(i+0.5)*Anchura,1.1),
          deepgreen, Arrow(5bp));
    }

// Las fracciones
label("$\frac{2}{5}$", (0,2.5+2*SeparacionVertical), W);
label("$\frac{6}{15}$", (20*Anchura,2.5+2*SeparacionVertical), W);
label("$\frac{1}{3}$", (0,1.5+SeparacionVertical), W);
label("$\frac{5}{15}$", (20*Anchura,1.5+SeparacionVertical), W);
label("$\frac{11}{15}$", (SeparacionHorizontal+15*Anchura,0.5), E);
