//---------------------------------------------------------------
// Fichero:  TresOctavos.asy
// Objetivo: Dibujar tres octavos en un rectángulo
// Fecha:    S.13.2.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// Definimos el cuadrado pequeño
path Cuadrado = box((0,0), (1,1));

// Los tres cuadrados pequeños marcados
for (int i = 0; i <= 2; ++i)
    { fill(shift(i, 1) * Cuadrado, mediumgray); }

// Dibujamos ocho veces el cuadrado pequeño, con desplazamientos
for (int i = 0; i <= 3; ++i)
    {
    for (int j = 0; j <= 1; ++j)
        { draw(shift(i, j) * Cuadrado); }
    }
