//---------------------------------------------------------------
// Fichero:  OchoDieciseisavos.asy
// Objetivo: Dibujar ocho diciseisavos en un cuadrado
// Fecha:    J.18.2.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// Los cuatro triángulos marcados
fill(((0,0) -- (4,0) -- (2,1) -- cycle), mediumgray);
fill(((4,0) -- (4,4) -- (3,2) -- cycle), mediumgray);
fill(((4,4) -- (0,4) -- (2,3) -- cycle), mediumgray);
fill(((0,0) -- (1,2) -- (0,4) -- cycle), mediumgray);

// Definimos el cuadrado pequeño
path Cuadrado = box((0,0), (1,1));

// Dibujamos cuatro filas de cuatro cuadrados
for ( int i=0; i<4; ++i )
    {
    for ( int j=0 ; j<4; ++j )
        { draw(shift(i, j) * Cuadrado); }
    }
