//---------------------------------------------------------------
// Fichero:  TresSeptimos.asy
// Objetivo: Dibujar tres séptimos en un heptágono
// Fecha:    D.14.2.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(2cm);

// Grosor de las líneas
defaultpen(1);

// El sector básico
real Angulo = 360/7;
path Sector = ((0,0) -- (1,0) -- (Cos(Angulo), Sin(Angulo)) -- cycle);

// Rellenamos tres sectores
fill(Sector, mediumgray);
fill(rotate(Angulo*2) * Sector, mediumgray);
fill(rotate(Angulo*4) * Sector, mediumgray);

// El heptágono
for ( int i=0 ; i<=6 ; ++i )
  { draw(rotate(Angulo*i) * Sector); }
