//---------------------------------------------------------------
// Fichero:  ejemplo1.asy
// Objetivo: Mostrar el ejemplo 1
// Fecha:    V.2.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 10, Ymin = 0, Ymax = 10, Extra = 0.25;

// Definición de los puntos
pair A=(9,9), B=(8,4), C=(2,3), D=(4,5), E1=(10,8);
pair F=(7,5), G=(4,2), H=(8,7), I=(6,10), J=(5,6);

// Grosor de las líneas
defaultpen(1);

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(10pt);

// El eje de ordenadas
yaxis("Naturales", ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis("Sociales", xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Los puntos
dot(Label("A"), A, N, 5pt+black);
dot(Label("B"), B, E, 5pt+black);
dot(Label("C"), C, N, 5pt+black);
dot(Label("D"), D, S, 5pt+black);
dot(Label("E"), E1, S, 5pt+black);
dot(Label("F"), F, E, 5pt+black);
dot(Label("G"), G, S, 5pt+black);
dot(Label("H"), H, W, 5pt+black);
dot(Label("I"), I, S, 5pt+black);
dot(Label("J"), J, N, 5pt+black);
