//---------------------------------------------------------------
// Fichero:  ejemplo.asy
// Objetivo: Mostrar un ejemplo
// Fecha:    X.31.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(7cm);

// Grosor de las líneas
defaultpen(1);

// El punto
pair P=(1.4,0.75);

// Las líneas que indican abscisa y ordenada
pen Punteado = linetype(new real[] {2,2});
draw((1.4,0) -- P, Punteado+gray);
draw((0,0.75) -- P, Punteado+gray);

// Dimensiones de los ejes
real Xmin = -0.2, Xmax = 2, Ymin = -0.25, Ymax = 1, Extra = 0.1;

// Formato de marcas los ejes
ticks FormatoTicksX = Ticks(Step=1, step=0.2, NoZero, Size=1mm, size=0.5mm,
                      pTick=blue);
ticks FormatoTicksY = Ticks(Step=1, step=0.25, NoZero, Size=1mm, size=0.5mm,
                      pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicksX);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicksY);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El punto
dot(Label("P=$\left( \frac{7}{5},\frac{3}{4}\right )$"), P, NE, 5pt+black);

