//---------------------------------------------------------------
// Fichero:  ejercicio.asy
// Objetivo: Mostrar un ejercicio resuelto
// Fecha:    L.29.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(18cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los puntos
pair A=(3.2,3.9), B=(-3.8,2.6), C=(-1.9,-3), D=(3.9,-0.8), F=(1.3,0);
pair G=(0,2.6), H=(-0.8,0), I=(0,-3.3), J=(2.1,1.7), K=(-2.5,1);
pair L=(-3,-1.6), M=(2.4,-2.7), Q=(0.2,0.4), R=(-3.1,0.8), T=(-2,-1.8);

// Dimensiones de los ejes
real Xmin = -4, Xmax = 4, Ymin = -4, Ymax = 4, Extra = 0.1;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, step=0.1, NoZero, Size=1mm, size=0.5mm,
                     pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los puntos
dot(Label("A"), A, S, 5pt+black);
dot(Label("B"), B, E, 5pt+black);
dot(Label("C"), C, S, 5pt+black);
dot(Label("D"), D, S, 5pt+black);
dot(Label("F"), F, N, 5pt+black);
dot(Label("G"), G, E, 5pt+black);
dot(Label("H"), H, N, 5pt+black);
dot(Label("I"), I, E, 5pt+black);
dot(Label("J"), J, NE, 5pt+black);
dot(Label("K"), K, N, 5pt+black);
dot(Label("L"), L, S, 5pt+black);
dot(Label("M"), M, S, 5pt+black);
dot(Label("Q"), Q, E, 5pt+black);
dot(Label("R"), R, N, 5pt+black);
dot(Label("T"), T, S, 5pt+black);
