//---------------------------------------------------------------
// Fichero:  ejercicio.asy
// Objetivo: Mostrar ejercicios resueltos
// Fecha:    D.28.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(12cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los puntos
pair A=(8,1), B=(-4,-3), C=(2,0), D=(-8,4), E1=(0,-4);
pair F=(4,2), G=(-3,0), H=(6,-2), I=(0,3), J=(-7,-1);

// Dimensiones de los ejes
real Xmin = -9, Xmax = 9, Ymin = -5, Ymax = 5, Extra = 0.2;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los puntos
dot(Label("A"), A, N, 5pt+black);
dot(Label("B"), B, N, 5pt+black);
dot(Label("C"), C, N, 5pt+black);
dot(Label("D"), D, N, 5pt+black);
dot(Label("E"), E1, E, 5pt+black);
dot(Label("F"), F, N, 5pt+black);
dot(Label("G"), G, N, 5pt+black);
dot(Label("H"), H, N, 5pt+black);
dot(Label("I"), I, E, 5pt+black);
dot(Label("J"), J, S, 5pt+black);

