//---------------------------------------------------------------
// Fichero:  enunciado2.asy
// Objetivo: Mostrar el enunciado 2
// Fecha:    J.1.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(16cm);

// Dimensiones de los ejes
real Xmin = -10, Xmax = 10, Ymin = -6, Ymax = 6, Extra = 0.2;

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),1bp+gray));

// Definición de los puntos
pair A=(0,-1), B=(9,1), C=(0,-6), D=(0,4), F=(-7,-6);
pair G=(10,-5), H=(-3,5), I=(-8,3), J=(4,2), K=(-5,-3);
pair L=(-7,0), M=(6,6), Q=(8,-2), R=(3,-3), T=(6,-1);

// Grosor de las líneas
defaultpen(2);

// El eje de abscisas
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los puntos
dot(Label("A"), A, NE, 5pt+black);
dot(Label("B"), B, SW, 5pt+black);
dot(Label("C"), C, NW, 5pt+black);
dot(Label("D"), D, SW, 5pt+black);
dot(Label("F"), F, NE, 5pt+black);
dot(Label("G"), G, NW, 5pt+black);
dot(Label("H"), H, NW, 5pt+black);
dot(Label("I"), I, SW, 5pt+black);
dot(Label("J"), J, SE, 5pt+black);
dot(Label("K"), K, NE, 5pt+black);
dot(Label("L"), L, SE, 5pt+black);
dot(Label("M"), M, SW, 5pt+black);
dot(Label("Q"), Q, NE, 5pt+black);
dot(Label("R"), R, SW, 5pt+black);
dot(Label("T"), T, SW, 5pt+black);
