//---------------------------------------------------------------
// Fichero:  solucion2.asy
// Objetivo: Mostrar la solución 2
// Fecha:    X.31.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(16cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los puntos
pair A=(-1.3,1.8), B=(0,-1.3), C=(-3.1,0), D=(-2.5,1.5), F=(2.3,-1.8);
pair G=(1.7,-0.5), H=(-1.9,-1.5), I=(3.3,-0.3), J=(-1.4,0), K=(3.9,-1.9);
pair L=(0,0.1), M=(1.2,1), Q=(-0.1,-0.8), R=(-3.9,1), T=(1.2,-0.7);

// Dimensiones de los ejes
real Xmin = -4, Xmax = 4, Ymin = -2, Ymax = 2, Extra = 0.2;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, step=0.1, NoZero, Size=1mm, size=0.5mm,
                     pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los puntos
dot(Label("A"), A, S, 5pt+black);
dot(Label("B"), B, E, 5pt+black);
dot(Label("C"), C, N, 5pt+black);
dot(Label("D"), D, S, 5pt+black);
dot(Label("F"), F, N, 5pt+black);
dot(Label("G"), G, E, 5pt+black);
dot(Label("H"), H, N, 5pt+black);
dot(Label("I"), I, S, 5pt+black);
dot(Label("J"), J, N, 5pt+black);
dot(Label("K"), K, N, 5pt+black);
dot(Label("L"), L, NE, 5pt+black);
dot(Label("M"), M, S, 5pt+black);
dot(Label("Q"), Q, W, 5pt+black);
dot(Label("R"), R, N, 5pt+black);
dot(Label("T"), T, S, 5pt+black);
