//---------------------------------------------------------------
// Fichero:  solucion1.asy
// Objetivo: Mostrar la solución 1
// Fecha:    M.30.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(16cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los puntos
pair A=(3.8,1.9), B=(-1.6,1.2), C=(-2.1,-1.7), D=(3.5,-0.5), F=(3.4,0);
pair G=(0,1.5), H=(-2.8,0), I=(0,-1.6), J=(2.2,0.9), K=(-3.5,1.3);
pair L=(-3.3,-0.3), M=(1.4,-1.2), Q=(0.7,1), R=(-3.9,1.8), T=(-3.6,-1.9);

// Dimensiones de los ejes
real Xmin = -4, Xmax = 4, Ymin = -2, Ymax = 2, Extra = 0.2;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, step=0.1, NoZero, Size=1mm, size=0.5mm,
                     pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los puntos
dot(Label("A"), A, S, 5pt+black);
dot(Label("B"), B, N, 5pt+black);
dot(Label("C"), C, S, 5pt+black);
dot(Label("D"), D, S, 5pt+black);
dot(Label("F"), F, N, 5pt+black);
dot(Label("G"), G, E, 5pt+black);
dot(Label("H"), H, N, 5pt+black);
dot(Label("I"), I, E, 5pt+black);
dot(Label("J"), J, N, 5pt+black);
dot(Label("K"), K, N, 5pt+black);
dot(Label("L"), L, S, 5pt+black);
dot(Label("M"), M, S, 5pt+black);
dot(Label("Q"), Q, E, 5pt+black);
dot(Label("R"), R, N, 5pt+black);
dot(Label("T"), T, N, 5pt+black);
