//---------------------------------------------------------------
// Fichero:  solucion2.asy
// Objetivo: Mostrar la solución 2
// Fecha:    L.29.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(16cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los puntos
pair A=(1,0), B=(-4,5), C=(0,-5), D=(10,1), F=(4,4);
pair G=(-10,-1), H=(8,3), I=(0,3), J=(2,-2), K=(-7,-3);
pair L=(6,-3), M=(-7,4), Q=(1,5), R=(8,-1), T=(4,-1);

// Dimensiones de los ejes
real Xmin = -10, Xmax = 10, Ymin = -5, Ymax = 5, Extra = 0.5;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Los puntos
dot(Label("A"), A, N, 5pt+black);
dot(Label("B"), B, S, 5pt+black);
dot(Label("C"), C, E, 5pt+black);
dot(Label("D"), D, N, 5pt+black);
dot(Label("F"), F, N, 5pt+black);
dot(Label("G"), G, S, 5pt+black);
dot(Label("H"), H, N, 5pt+black);
dot(Label("I"), I, E, 5pt+black);
dot(Label("J"), J, E, 5pt+black);
dot(Label("K"), K, S, 5pt+black);
dot(Label("L"), L, S, 5pt+black);
dot(Label("M"), M, S, 5pt+black);
dot(Label("Q"), Q, E, 5pt+black);
dot(Label("R"), R, S, 5pt+black);
dot(Label("T"), T, S, 5pt+black);
